//
//  OPOpenSSLKEy.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-05-26.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface OPOpenSSLKey : NSObject

@property (nonatomic) size_t bufferSize;
@property (nonatomic, strong) NSData *keyData;

- (id)initWithKeyData:(NSData *)keyData;

- (BOOL)encryptWithSalt:(BOOL)useSalt reader:(NSData *(^)(size_t bytesToRead))reader writer:(void (^)(NSData *encrypted))writer error:(NSError **)error;
- (NSData *)encrypt:(NSData *)data useSalt:(BOOL)useSalt;

- (BOOL)decryptWithReader:(NSData *(^)(size_t bytesToRead))reader writer:(void (^)(NSData *plaintext))writer error:(NSError **)error;
- (NSData *)decrypt:(NSData *)data;


@end
